#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <GL/gl.h>
#include <GL/glu.h>
#include <math.h>
#include "../fmod/inc/fmod.h"
#include "SDL.h"
#define PI 3.14159265358979323846264
#define RADIAN(x) (x*(PI/180))
#define SCREEN_W 640
#define SCREEN_H 480
#define SCREEN_BPP 16

typedef struct {
  float x,y,z;
  float u, v;
} vertex;

typedef struct{
  float x0,y0,z0;
  float radius;
  int step, facets;
  vertex *vertices;
  GLuint texture[1];
} sphere_s;

typedef struct{
  vertex vertices[3];
  vertex normal;
  unsigned int r,g,b;
}triangle;

int initSDL( int *videoFlags, const SDL_VideoInfo *videoInfo );
vertex *renderSphere( sphere_s initvalues);
int resizeWindow( int width, int height );
void drawSphere( sphere_s initvalues, int sm );
void evaluateGrid(void);
void setupMesh(void);
int initobject( char *file );
void drawObject();
vertex calc_normals( triangle tri );
float sqrtf(float x);
int initGL( GLvoid );

SDL_Surface *screen;
sphere_s sphere;
sphere_s skysphere;

int font[65][4][4];

extern GLfloat grid4x4[4][4][3];


/* Spectrum code */
float *dspspect;
float curval;
int cline;
int spectrumcolor[40];

FMUSIC_MODULE *tuneptr;
FSOUND_STREAM *stream;

GLuint btexture[1];
GLuint texture[1];
GLuint credits[6];

/* identifier for display list */
GLuint spheredl;
